create or replace package body tbicds.PCK_NOTE is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
/*****
Description: Gets all cosigners for a site/region
******/
procedure GetCosignerRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*, t2.duz 
         FROM tbicds.app_user t,
              tbicds.fx_user t2
        WHERE t.fx_user_id = t2.fx_user_id 
          AND t2.region_id = :REGION_ID
          AND t2.site_id = :SITE_ID
          AND upper(t.name) 
              like upper(nvl(:SEARCH, t.name))
     ORDER BY upper(t.NAME) asc';
    
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
       
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;


/*****
Description: Gets all clinics for a site/region
******/
procedure GetClinicRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*
         FROM tbicds.utl_Clinic t
        WHERE t.region_id = :region_id
          AND t.site_id = :site_id 
          AND upper(t.clinic_label) 
              like upper(nvl(:SEARCH, t.clinic_label))
     ORDER BY upper(t.Clinic_label) asc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
   
    --open the result set
    open rs for v_vSQL
    using pi_nRegionID, 
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
     
end;


/*****
Description: Gets all note titles for a site/region
******/
procedure GetNoteTitleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vSearch                in varchar2,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is
     --var to hold like search
     v_vSearch varchar2(500) := '';

     --sql select
     v_vSQL varchar2(500) :=
      'SELECT t.*, 
              decode(t.is_consult,1,''Y'',''N'') as consult_yn
         FROM tbicds.utl_note_title t
        WHERE t.region_id = :REGION_ID
          AND t.site_id = :SITE_ID
          AND upper(t.note_title_label) 
              like upper(nvl(:SEARCH, t.note_title_label))
     ORDER BY upper(t.note_title_label) asc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --add % for like 
    v_vSearch := '%' || pi_vSearch || '%';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          v_vSearch;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient appointments for a site/region/dfn
******/
procedure GetPatientAppointmentRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
            
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*, 
              t2.clinic_label
         FROM tbicds.patient_appointment t,
              tbicds.utl_clinic t2
        WHERE t.region_id = :REGION_ID
          AND t.appt_clinic_id = t2.clinic_id
          AND t2.region_id = :REGION_ID 
          AND t2.site_id = :SITE_ID  
          AND t.site_id = :SITE_ID
          AND t.dfn = :DFN
          AND (t.appt_datetime > :FROM_DATE 
               AND t.appt_datetime < :TO_DATE)
     ORDER BY t.appt_datetime desc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nregionid,
          pi_nSiteID,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient visits for a site/region/dfn
******/
procedure GetPatientVisitRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.* 
        FROM tbicds.patient_visit t
       WHERE region_id = :REGION_ID
         AND site_id = :SITE_ID
         AND dfn = :DFN
         AND (t.visit_datetime > :FROM_DATE 
              AND t.visit_datetime < :TO_DATE)
    ORDER BY t.visit_datetime desc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;

/*****
Description: Gets all patient consults for a site/region/dfn
******/
procedure GetPatientConsultRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.* 
         FROM tbicds.patient_consult t
        WHERE region_id = :REGION_ID
          AND site_id = :SITE_ID
          AND dfn = :DFN
          AND (t.consult_datetime > :FROM_DATE 
              AND t.consult_datetime < :TO_DATE)
     ORDER BY t.consult_datetime desc';
     
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';

end;

/*****
Description: Gets all patient admissions for a site/region/dfn
******/
procedure GetPatientAdmissionRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_vDFN                   in varchar2,
      pi_dtFrom                 in date,
      pi_dtTo                   in date,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      )
is

     v_vSQL varchar2(500) :=
      'SELECT t.*
         FROM tbicds.patient_admission t 
        WHERE t.region_id = :REGION_ID 
          AND t.site_id = :SITE_ID 
          AND t.dfn = :DFN 
          AND (t.admit_datetime > :FROM_DATE 
              AND t.admit_datetime < :TO_DATE)
     ORDER BY admit_datetime desc';
begin

    po_nStatusCode    := 0;
    po_vStatusComment := '';
    
    --open the result set
    open rs for v_vSQL
    using pi_nregionid,
          pi_nSiteID,
          pi_vDFN,
          pi_dtFrom - 1,
          pi_dtTo + 1;
    commit;

exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
      
end;




end PCK_NOTE;
/

